#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Mandelbrot smooth psychedelicMod01.fsh  by   Daniel3141
//https://www.shadertoy.com/view/ssscRB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// This is an enhanced and modified version of the smooth Mandelbrot version by 
// Inigo Quilez, @iquilezles and iquilezles.org https://www.shadertoy.com/view/4df3Rn


#define AA 2              // 1..8  Anti Aliasing: increase this if you have a very fast GPU
#define SMOOTH 1          // 0 or 1
#define PSYCHODELIC 1     // 0 .. 3 (only works with SMOOTH == 1)
#define ZOOM_TO_REGION 1  // 1 .. 3
#define MIN_ZOOM 1.6
#define MAX_ZOOM 0.00007  // deeper zoom is not possible because of 'float' limitations
#define SPEED 1.0
#define START_FADE_IN 1   // 0 or 1


float mandelbrot( in vec2 c )
{
    #if 1
    {
        float c2 = dot(c, c);
        // skip computation inside M1 - https://iquilezles.org/articles/mset1bulb
        if( 256.0*c2*c2 - 96.0*c2 + 32.0*c.x - 3.0 < 0.0 ) return 0.0;
        // skip computation inside M2 - https://iquilezles.org/articles/mset2bulb
        if( 16.0*(c2+2.0*c.x+1.0) - 1.0 < 0.0 ) return 0.0;
    }
    #endif


    const float B = 256.0;
    float l = 0.0;
    vec2 z  = vec2(0.0);
    for( int i=0; i<512; i++ ) {
        z = vec2( z.x*z.x - z.y*z.y, 2.0*z.x*z.y ) + c;
        if( dot(z,z) > (B*B) ) break;
        l += 1.0;
    }

    float maxIterations = 511.0;
#if START_FADE_IN==1
    if (iTime < 7.0 && iTime > 0.01) {
       maxIterations = pow(iTime + 1.0, 2.0);
    }
#endif
    if (l > maxIterations) return 0.0;
    
#if SMOOTH==1
    float diff = log2(log2(dot(z,z))) - 4.0;
    
 #if PSYCHODELIC>0
    if (diff < 0.04) return 0.0;
  #if PSYCHODELIC==1 
    diff = diff * 13.0;
  #elif PSYCHODELIC==2 
    diff = 3.5 / diff;
  #endif
 #endif

#else
    const float diff = 0.0;
#endif

    return l - diff;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 color = vec3(0.0);
    vec2 offset = vec2(-0.745, 0.0);
    
#if ZOOM_TO_REGION==1
    vec2 zoomTo = vec2(-0.742513, -0.143715) - offset; // zoom to 'self'
#elif ZOOM_TO_REGION==2
    vec2 zoomTo = vec2(-0.15828, 1.0386) - offset; // zoom to 'self'
#elif ZOOM_TO_REGION==3
    vec2 zoomTo = vec2(-1.401155, 0.0) - offset;
#else
    vec2 zoomTo = vec2(0.0, 0.186);
#endif


#if AA>1
    for( int m=0; m<AA; m++ )
    for( int n=0; n<AA; n++ )
    {
        vec2 p = (-iResolution.xy + 2.0*(fragCoord.xy+vec2(float(m),float(n))/float(AA)))/iResolution.y;
        float time = iTime*0.5*SPEED; 
#else    
        vec2 p = (-iResolution.xy + 2.0*fragCoord.xy)/iResolution.y;
        float time = iTime*0.5*SPEED;
#endif
    
        float z = 0.5 + 0.5*cos(.25*time); // 0.0 .. 1.0
        float zz = pow( z, 4.0);
        float zoom = MAX_ZOOM*(1.0-zz) + MIN_ZOOM*zz; // values 0.0x .. 1.0
        float coa = cos( 0.25*(1.0-z)*time );
        float sia = sin( 0.25*(1.0-z)*time );
        
        vec2 xy = vec2( p.x*coa-p.y*sia, p.x*sia+p.y*coa);
        vec2 c =  xy*zoom + offset + (1.0-zoom)*zoomTo;

        float l = mandelbrot(c);

        if (l > 0.001) { // do color mapping only for "non-black" values
           color += 0.5 + 0.5*cos( l*0.10 + 3.0 + vec3(0.0, 0.6, 1.0));
        }
        
#if AA>1
    }
    color /= float(AA*AA);
#endif

    fragColor = vec4( color, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

